/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.rolling_mill;

import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.recipe.rolling.RollingRecipe;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandler;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemTransferable;
import io.github.fabricators_of_create.porting_lib.transfer.item.RecipeWrapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class RollingMillTileEntity
extends KineticTileEntity
implements ItemTransferable {
    public ItemStackHandler inputInv = new ItemStackHandler(1);
    public ItemStackHandler outputInv = new ItemStackHandler(9);
    public Storage<ItemVariant> storage = new RollingMillInventoryHandler();
    public int timer;
    private RollingRecipe lastRecipe;
    private static final int STRESS = (Integer)Config.ROLLING_MILL_STRESS.get();
    private static final int DURATION = (Integer)Config.ROLLING_MILL_PROCESSING_DURATION.get();

    public RollingMillTileEntity(class_2591<? extends RollingMillTileEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        for (int i = 0; i < this.outputInv.getSlots(); ++i) {
            if (this.outputInv.getStackInSlot(i).method_7947() != this.outputInv.getSlotLimit(i)) continue;
            return;
        }
        if (this.timer > 0) {
            this.timer -= this.getProcessingSpeed();
            assert (this.field_11863 != null);
            if (this.field_11863.field_9236) {
                this.spawnParticles();
                return;
            }
            if (this.timer <= 0) {
                this.process();
            }
            return;
        }
        if (this.inputInv.getStackInSlot(0).method_7960()) {
            return;
        }
        RecipeWrapper inventoryIn = new RecipeWrapper(this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, Objects.requireNonNull(this.field_11863))) {
            assert (this.field_11863 != null);
            Optional<RollingRecipe> recipe = this.find(inventoryIn, this.field_11863);
            if (recipe.isEmpty()) {
                this.timer = 100;
                this.sendData();
            } else {
                this.lastRecipe = recipe.get();
                this.timer = RollingMillTileEntity.getProcessingDuration();
                this.sendData();
            }
            return;
        }
        this.timer = RollingMillTileEntity.getProcessingDuration();
        this.sendData();
    }

    private void process() {
        RecipeWrapper inventoryIn = new RecipeWrapper(this.inputInv);
        if (this.lastRecipe == null || !this.lastRecipe.matches(inventoryIn, Objects.requireNonNull(this.field_11863))) {
            assert (this.field_11863 != null);
            Optional<RollingRecipe> recipe = this.find(inventoryIn, this.field_11863);
            if (recipe.isEmpty()) {
                return;
            }
            this.lastRecipe = recipe.get();
        }
        class_1799 result = this.lastRecipe.assemble(inventoryIn).method_7972();
        try (Transaction t = TransferUtil.getTransaction();){
            this.outputInv.insert(ItemVariant.of((class_1799)result), (long)result.method_7947(), (TransactionContext)t);
            t.commit();
        }
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        stackInSlot.method_7934(1);
        this.inputInv.setStackInSlot(0, stackInSlot);
        this.sendData();
        this.method_5431();
    }

    public void spawnParticles() {
        class_1799 stackInSlot = this.inputInv.getStackInSlot(0);
        if (stackInSlot.method_7960()) {
            return;
        }
        class_2392 data = new class_2392(class_2398.field_11218, stackInSlot);
        assert (this.field_11863 != null);
        float angle = this.field_11863.field_9229.method_43057() * 360.0f;
        class_243 offset = new class_243(0.0, 0.0, 0.5);
        offset = VecHelper.rotate((class_243)offset, (double)angle, (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 target = VecHelper.rotate((class_243)offset, (double)(this.getSpeed() > 0.0f ? 25.0 : -25.0), (class_2350.class_2351)class_2350.class_2351.field_11052);
        class_243 center = offset.method_1019(VecHelper.getCenterOf((class_2382)this.field_11867));
        target = VecHelper.offsetRandomly((class_243)target.method_1020(offset), (class_5819)this.field_11863.field_9229, (float)0.0078125f);
        this.field_11863.method_8406((class_2394)data, center.field_1352, center.field_1351, center.field_1350, target.field_1352, target.field_1351, target.field_1350);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10569("Timer", this.timer);
        compound.method_10566("InputInventory", (class_2520)this.inputInv.serializeNBT());
        compound.method_10566("OutputInventory", (class_2520)this.outputInv.serializeNBT());
        super.write(compound, clientPacket);
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.timer = compound.method_10550("Timer");
        this.inputInv.deserializeNBT(compound.method_10562("InputInventory"));
        this.outputInv.deserializeNBT(compound.method_10562("OutputInventory"));
        super.read(compound, clientPacket);
    }

    public int getProcessingSpeed() {
        return class_3532.method_15340((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 face) {
        return this.storage;
    }

    private boolean canProcess(class_1799 stack) {
        ItemStackHandler tester = new ItemStackHandler(1);
        tester.setStackInSlot(0, stack);
        RecipeWrapper inventoryIn = new RecipeWrapper(tester);
        if (this.lastRecipe != null) {
            assert (this.field_11863 != null);
            if (this.lastRecipe.matches(inventoryIn, this.field_11863)) {
                return true;
            }
        }
        assert (this.field_11863 != null);
        return this.find(inventoryIn, this.field_11863).isPresent();
    }

    public Optional<RollingRecipe> find(RecipeWrapper inv, class_1937 world) {
        return world.method_8433().method_8132(RollingRecipe.TYPE, (class_1263)inv, world);
    }

    public static int getProcessingDuration() {
        return DURATION;
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)STRESS;
        return impact;
    }

    private class RollingMillInventoryHandler
    extends CombinedStorage<ItemVariant, ItemStackHandler> {
        public RollingMillInventoryHandler() {
            super(List.of(RollingMillTileEntity.this.inputInv, RollingMillTileEntity.this.outputInv));
        }

        public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            if (RollingMillTileEntity.this.canProcess(resource.toStack())) {
                return RollingMillTileEntity.this.inputInv.insert(resource, maxAmount, transaction);
            }
            return 0L;
        }

        public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
            return RollingMillTileEntity.this.outputInv.extract(resource, maxAmount, transaction);
        }
    }
}

